import { ModalsPluginWeb, WebPlugin } from "@capacitor/core";
const webModals = new ModalsPluginWeb();
const { dialog, getCurrentWindow } = require("electron").remote;
export class ModalsPluginElectron extends WebPlugin {
    constructor() {
        super({
            name: "Modals",
            platforms: ["electron"],
        });
    }
    async alert(options) {
        const buttons = [options.buttonTitle || "OK"];
        await dialog.showMessageBox(getCurrentWindow(), {
            message: options.message,
            title: options.title,
            buttons,
        });
    }
    async prompt(options) {
        const val = window.prompt(options.message, options.inputText || "");
        return Promise.resolve({
            value: val,
            cancelled: val === null,
        });
    }
    async confirm(options) {
        const buttons = [
            options.okButtonTitle || "OK",
            options.cancelButtonTitle || "Cancel",
        ];
        const value = await dialog.showMessageBox(getCurrentWindow(), {
            message: options.message,
            title: options.title,
            buttons,
        });
        return { value: value.response === 0 };
    }
    async showActions(options) {
        return webModals.showActions(options);
    }
}
const Modals = new ModalsPluginElectron();
export { Modals };
//# sourceMappingURL=modals.js.map